//
//  PayKKaEnv.h
//  PayKKaCheckoutPayments
//
//  Created by jiangzheng on 2025/11/27.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

/// SDK 运行环境配置
@interface PayKKaEnv : NSObject

#pragma mark - 环境静态实例

/// 沙箱环境 (SANDBOX)
@property (class, nonatomic, readonly) PayKKaEnv *SANDBOX;

/// 欧洲生产环境 (PROD_EU)
@property (class, nonatomic, readonly) PayKKaEnv *PROD_EU;

/// 香港生产环境 (PROD_HK)
@property (class, nonatomic, readonly) PayKKaEnv *PROD_HK;

#pragma mark - 实例属性与方法

/// 结账页面的 URL 格式模板
@property (nonatomic, readonly) NSString *checkoutUrlFormat;

/// 使用指定的 URL 格式模板初始化环境
///
/// - Parameter format: URL 格式模板字符串，通常包含 `{sessionId}` 占位符
/// - Returns: `PayKKaEnv` 实例
- (instancetype)initWithFormat:(NSString *)format NS_DESIGNATED_INITIALIZER;

/// 根据 Session ID 生成完整的支付页面 URL
///
/// 使用内部模板替换 `{sessionId}` 占位符生成完整 URL。
///
/// - Parameter sessionId: PayKKa 创建的结账 Session ID
/// - Returns: 完整的支付页面 URL
/// - Throws: 当生成 URL 失败时抛出 `NSInvalidArgumentException` 异常
- (NSURL *)checkoutWebUrlWithSessionId:(NSString *)sessionId;

- (instancetype)init NS_UNAVAILABLE;

@end

NS_ASSUME_NONNULL_END
