//
//  PayKKa.h
//  PayKKaCheckoutPayments
//
//  Created by jiangzheng on 2025/11/27.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>
#import <PayKKaCheckoutPayments/PayKKaEnv.h>
#import <PayKKaCheckoutPayments/PaymentResult.h>
#import <PayKKaCheckoutPayments/PayKKaWKWebViewController.h>

NS_ASSUME_NONNULL_BEGIN

/// PayKKa 支付结果回调
///
/// - Parameter paymentResult: 包含支付状态和详情的结果对象
typedef void(^PayKKaCallback)(PaymentResult *paymentResult);

/// PayKKa SDK 主入口
@interface PayKKa : NSObject

/// 日志输出的标签
@property (class, nonatomic, readonly) NSString *TAG;

/// 支付结果存储的字段名称
@property (class, nonatomic, readonly) NSString *PaymentResultIntentExtraFieldName;

/// SDK 当前使用的环境配置
@property (class, nonatomic) PayKKaEnv *currentEnv;

/// 切换 SDK 使用的环境
///
/// - Parameter env: 要使用的 PayKKaEnv 实例
+ (void)useEnv:(PayKKaEnv *)env;

/// 发起支付流程，展示收银台页面
///
/// 使用内部的 `PayKKaWKWebViewController` 在 `UINavigationController` 中展示 H5 收银台。
///
/// - Parameters:
///   - from: 当前视图控制器，支付页面将从此控制器弹出
///   - sessionId: PayKKa 创建的结账 Session ID，用于生成支付页面 URL
///   - onPaymentCallback: 支付完成后的回调，包含支付结果
+ (void)goPay:(UIViewController *)from sessionId:(NSString *)sessionId
                                onPaymentCallback:(void (^)(PaymentResult * paymentResult))onPaymentCallback;

/// 发起支付流程，展示收银台页面
///
/// 使用内部的 `PayKKaWKWebViewController` 在 `UINavigationController` 中展示 H5 收银台。
///
/// - Parameters:
///   - from: 当前视图控制器，支付页面将从此控制器弹出
///   - sessionId: PayKKa 创建的结账 Session ID，用于生成支付页面 URL
///   - onPaymentCallback: 支付完成后的回调，包含支付结果
///   - onCloseTappedCallback: 用户点击关闭按钮时的回调函数
+ (void)goPay:(UIViewController *)from sessionId:(NSString *)sessionId
                               onPaymentCallback:(void (^)(PaymentResult * paymentResult))onPaymentCallback
                           onCloseTappedCallback:(void (^)(JSEvent * jsEvent))onCloseTappedCallback
;

@end

NS_ASSUME_NONNULL_END
