//
//  JSEvent.h
//  PayKKaCheckoutPayments
//
//  Created by jiangzheng on 2025/12/2.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

/// 收银台 JS 事件类型枚举
typedef NS_ENUM(NSInteger, JSEventType) {
    /// 未知事件
    EventTypeUnknown = 0,
    /// 用户点击了关闭收银台按钮
    EventTypeClose,
};

/// 接收自 Web 端的 JS 事件封装类
@interface JSEvent : NSObject

/// 事件类型
@property (nonatomic, assign, readonly) JSEventType type;

/// 事件携带的原始数据
@property (nonatomic, strong, readonly, nullable) NSDictionary *data;

/// 标准化的 JS 事件字典对象
@property (nonatomic, strong, readonly) NSDictionary *jsEventObj;

/// 使用事件类型和数据初始化 JS 事件实例
///
/// - Parameters:
///   - type: 事件类型，参考 `JSEventType`
///   - data: 事件附加数据字典
/// - Returns: `JSEvent` 实例
- (instancetype)initWithType:(JSEventType)type
                        data:(NSDictionary *)data;

/// 生成标准化的 JS 事件字典
///
/// - Parameters:
///   - type: 事件类型
///   - data: 事件数据
/// - Returns: 标准化的 `NSDictionary`，包含 `type` 和 `data` 字段
+ (NSDictionary *)makeResult:(JSEventType)type
                        data:(NSDictionary *)data;

#pragma mark - JSON 解析与序列化

/// 从 JSON 字符串创建 `JSEvent` 实例
///
/// - Parameter jsonString: JSON 格式的事件字符串
/// - Returns: `JSEvent` 实例
+ (instancetype)fromString:(NSString *)jsonString;

/// 将 `JSEvent` 实例转换为 JSON 字符串
///
/// - Returns: JSON 格式字符串
- (NSString *)toString;

@end

NS_ASSUME_NONNULL_END
