//
//  PayKKaWKWebViewController.h
//  PayKKaCheckoutPayments
//
//  Created by jiangzheng on 2025/11/27.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>
#import <WebKit/WebKit.h>
#import <PayKKaCheckoutPayments/PaymentResult.h>
#import <PayKKaCheckoutPayments/JSEvent.h>

NS_ASSUME_NONNULL_BEGIN

/// 内部使用的 Web 视图控制器，用于展示收银台
@interface PayKKaWKWebViewController : UIViewController
/// 当前正在展示的 Web 视图控制器实例
+ (PayKKaWKWebViewController *)currentWebVc;
+ (void)setCurrentWebVc:(PayKKaWKWebViewController *)currentWebVc;

/// 当前加载的支付页面 URL
@property (nonatomic, strong, readonly) NSURL *url;

/// 使用指定的 URL 初始化 Web 视图控制器
///
/// - Parameter url: 要加载的收银台 URL
/// - Returns: `PayKKaWKWebViewController` 实例
- (instancetype)initWithURL:(NSURL *)url;

/// 关闭并隐藏当前的 Web 视图控制器
- (void)hide;

/// 隐藏当前活动的 Web 视图控制器实例
+ (void)hideCurrentWebVc;

#pragma mark - 回调管理

/// 设置全局支付结果回调
///
/// - Parameter callback: 支付结果回调 Block
+ (void)setPaymentCallback:(void (^)(PaymentResult * result))callback;

/// 触发当前设置的支付结果回调
///
/// - Parameter paymentResult: 支付结果对象
+ (void)triggerPaymentCallback:(PaymentResult *)paymentResult;

/// 清除已设置的支付结果回调
+ (void)resetPaymentCallback;

/// 设置用户点击关闭按钮的回调
///
/// - Parameter callback: 关闭事件回调 Block
+ (void)setOnCloseTappedCallback:(void (^)(JSEvent * event))callback;

/// 触发用户点击关闭按钮的回调
///
/// - Parameter event: 触发的 JS 事件对象
+ (void)triggerOnCloseTappedCallback:(JSEvent *)event;

/// 清除已设置的关闭按钮回调
+ (void)resetOnCloseTappedCallback;

@end

NS_ASSUME_NONNULL_END
