//
//  NavigationRouter.swift
//  SwiftCheckoutDemo
//
//  Created by jiangzheng on 2025/11/28.
//

import Foundation

enum Page: Hashable {
    case confirm_order(extraData: [String: AnyHashable])
    case payment_complete(extraData: [String: AnyHashable])
}

class NavigationRouter: ObservableObject {
    @Published var path: [Page] = []

    // 跳转到某个页面
    func push(_ page: Page) {
        path.append(page)
    }

    // 重定向：清空并跳转到指定页面
    func redirect(to page: Page) {
        path = [page]
    }

    // 返回上一页
    func back() {
        _ = path.popLast()
    }

    // 回到根页面
    func backToRoot() {
        path.removeAll()
    }
}

