//
//  PaymentComplete.swift
//  SwiftCheckoutDemo
//
//  Created by jiangzheng on 2025/11/28.
//

import SwiftUI
import PayKKaCheckoutPayments

struct PaymentComplete: View {
    let paymentResult: PaymentResult
    var body: some View {
        switch paymentResult.status {
        case .success:
            VStack {
                Image(systemName: "checkmark.circle.fill")
                    .resizable()
                    .aspectRatio(contentMode: .fit)
                    .foregroundColor(.green)
                    .frame(width: 110, height: 110)
                    .padding(.bottom, 100)
                Text("Pay Success")
            }
        case .expired:
            VStack {
                Image(systemName: "exclamationmark.triangle.fill")
                    .resizable()
                    .aspectRatio(contentMode: .fit)
                    .foregroundColor(.orange)
                    .frame(width: 110, height: 110)
                    .padding(.bottom, 100)
                Text("The checkout session has expired. Please initiate the payment again.")
                    .multilineTextAlignment(.center)
            }
        case .error:
            Image(systemName: "xmark.circle.fill")
                .resizable()
                .aspectRatio(contentMode: .fit)
                .foregroundColor(.red)
                .frame(width: 110, height: 110)
                .padding(.bottom, 100)
            Text("Failed, please try again later")
        default:
            Text("Error: payment result status")
        }
    }
}

#Preview {
    PaymentComplete(paymentResult: PaymentResult(status: .success, result: [:], message: "Success!"))
}
