//
//  HomeView.swift
//  SwiftCheckoutDemo
//
//  Created by jiangzheng on 2025/11/26.
//

import SwiftUI
import PayKKaCheckoutPayments

struct SettingItem: Identifiable {
    let id = UUID()
    let title: String
    let subtitle: String?
    let page: Page
}

struct SettingSection: Identifiable {
    let id = UUID()
    let title: String?
    let items: [SettingItem]
}

struct Home: View {
    @EnvironmentObject var router: NavigationRouter

    let sections: [SettingSection] = [
        SettingSection(title: "", items: [
            SettingItem(
                title: "打开收银台",
                subtitle: "WebView方式",
                page: .confirm_order(extraData: ["sessionId": "CS208693570923680499"])
            )
        ])
    ]
    
    var body: some View {
        NavigationView {
            List {
                ForEach(sections) { section in
                    Section(header: Text(section.title ?? "")) {
                        ForEach(section.items) { item in
                            Button(action: {
                                router.push(item.page)
                            }) {
                                HStack {
                                    Text(item.title)
                                    Spacer()
                                    Text(item.subtitle ?? "").font(.system(size: 14)).foregroundStyle(Color(.systemGray))
                                    Image(systemName: "chevron.right")
                                }
                            }
                        }
                    }
                }
            }
            .navigationTitle("Checkout Demo")
        }
    }
}

#Preview {
    Home()
}
