//
//  ConfirmOrder.swift
//  SwiftCheckoutDemo
//
//  Created by jiangzheng on 2025/11/26.
//

import SwiftUI
import PayKKaCheckoutPayments

struct ConfirmOrder: View {
    @EnvironmentObject var router: NavigationRouter

    @State private var showWebView = false
    private let sessionId: String

    let price: Double = 1118.83;
    var body: some View {
        ScrollView {
            Color.clear.padding(.vertical, 4)
            VStack {
                HStack {
                    Text("数码旗舰店").bold()
                    Spacer()
                }
                .padding(.vertical, 12)
                .padding(.horizontal, 12)
                .overlay(Rectangle().frame(height: 0.5).foregroundColor(.gray).opacity(0.2), alignment: .bottom)
                HStack {
                    Image(systemName: "keyboard")
                        .resizable()
                        .aspectRatio(contentMode: .fit)
                        .frame(width: 50, height: 50)
                        .foregroundStyle(Color(.blue))
                        .padding()
                        .background(Color(.systemGray4))
                        .cornerRadius(12)
                    HStack {
                        VStack {
                            HStack(alignment: .bottom, spacing: 0) {
                                Text("87 Keyboard").bold()
                                Spacer()
                                Text("券后").bold()
                                Group {
                                    Text("¥").bold()
                                    Text("\(price.intPart).\(price.fracPart)").bold()
                                }
                                .foregroundStyle(.blue)
                            }
                            .font(.system(size: 15))
                            .padding(.vertical, 8)

                            Group {
                                HStack {
                                    Text("SKU: KB-MECH87-BLUE-SW-V2")
                                    Spacer()
                                }
                                HStack {
                                    Text("Color: Midnight Blue")
                                    Spacer()
                                }
                            }
                            .font(.system(size: 14))
                            .opacity(0.5)
                            Spacer()
                        }
                    }
                }
                .padding(.horizontal, 12)
                .padding(.top, 12)

                HStack {
                    Button {} label: {
                        HStack(spacing: 0) {
                            Text("备注").bold().font(.system(size: 14))
                            Spacer()
                            Group {
                                Text("无备注").bold()
                                Image(systemName: "chevron.right")
                            }
                            .font(.system(size: 14))
                            .opacity(0.5)
                        }
                        .padding(.vertical, 12)
                    }
                }
                .padding(.horizontal, 12)
                .padding(.vertical, 8)
            }
            .background()
            .cornerRadius(12)
            .padding(.horizontal, 16)
            Color.clear.padding(.vertical, 4)
        }
        .background(Color(.systemGray6))
        .paykkaPaymentWKWebViewSheet(isPresented: $showWebView, sessionId: sessionId, onPaymentResultCallback: { paymentResult in
            print("---->", paymentResult.toString())
            switch paymentResult.status {
            case .success:
                router.redirect(to: .payment_complete(extraData: ["paymentResult": paymentResult]))
            case .expired:
                router.redirect(to: .payment_complete(extraData: ["paymentResult": paymentResult]))
                print("onExpired: \(paymentResult.toString())")
            default:
                print("Unhandled payment status: \(paymentResult.status)")
            }
        })
        .navigationTitle("确认订单")
        .navigationBarTitleDisplayMode(.inline)
        HStack {
            Button {
                showWebView = true
            } label: {
                HStack(alignment: .bottom, spacing: 0) {
                    Text("立即支付")
                    Text("¥")
                    Text("\(price.intPart)").padding(0)
                    Text(".\(price.fracPart)").font(.system(size: 14))
                }
                .bold()
                .frame(maxWidth: .infinity)
                .foregroundColor(.white)
                .padding(.vertical, 12)
                .padding(.horizontal, 20)
                .background(.blue)
                .cornerRadius(12)
            }
        }
        .padding(.horizontal, 20)
        .padding(.vertical, 10)
    }
    
    init(showWebView: Bool = false, sessionId: String) {
        /// Use your PayKKa API Env
        PayKKa.use(.sandbox)
        self.showWebView = showWebView
        self.sessionId = sessionId
    }
}

extension Double {
    var intPart: Int {
        Int(self)
    }
    
    var fracPart: Int {
        Int((self - Double(intPart)) * 100)
    }
}

#Preview {
    ConfirmOrder(sessionId: "CS208693570923680499")
}
