//
//  ContentView.swift
//  SwiftCheckoutDemo
//
//  Created by jiangzheng on 2025/11/26.
//

import SwiftUI
import PayKKaCheckoutPayments

struct Index: View {
    @EnvironmentObject var router: NavigationRouter

    var body: some View {
        NavigationStack(path: $router.path) {
            Home()
                .navigationDestination(for: Page.self) { page in
                    switch page {
                    case .confirm_order(let extraData):
                        if let sessionId = extraData["sessionId"] as? String {
                            ConfirmOrder(sessionId: sessionId)
                        } else {
                            Text("无效 URL")
                        }
                    case .payment_complete(let extraData):
                        if let paymentResult = extraData["paymentResult"] as? PaymentResult {
                            PaymentComplete(paymentResult: paymentResult)
                        } else {
                            Text("Error...")
                        }
                    }
                }
        }
    }
}

#Preview {
    Index()
}
