//
//  PaymentCompleteViewController.m
//  OcCheckoutDemo
//
//  Created by jiangzheng on 2025/12/1.
//

#import "PaymentCompleteViewController.h"

NS_ASSUME_NONNULL_BEGIN

@implementation PaymentCompleteViewController

- (instancetype)initWithPaymentResult:(PaymentResult *)paymentResult {
    self = [super init];
    if (self) {
        _paymentResult = paymentResult;
    }
    return self;
}

- (void)viewDidLoad {
    [super viewDidLoad];
    self.view.backgroundColor = [UIColor systemBackgroundColor];

    [self buildUI];
}

- (void)buildUI {

    UIStackView *stack = [[UIStackView alloc] init];
    stack.axis = UILayoutConstraintAxisVertical;
    stack.alignment = UIStackViewAlignmentCenter;
    stack.spacing = 20;
    stack.translatesAutoresizingMaskIntoConstraints = NO;

    [self.view addSubview:stack];

    [NSLayoutConstraint activateConstraints:@[
        [stack.centerXAnchor constraintEqualToAnchor:self.view.centerXAnchor],
        [stack.centerYAnchor constraintEqualToAnchor:self.view.centerYAnchor]
    ]];

    UIImageView *icon = [[UIImageView alloc] init];
    icon.translatesAutoresizingMaskIntoConstraints = NO;
    icon.contentMode = UIViewContentModeScaleAspectFit;

    UILabel *label = [[UILabel alloc] init];
    label.font = [UIFont systemFontOfSize:20 weight:UIFontWeightSemibold];

    switch (self.paymentResult.status) {

        case PaymentStatusSuccess:
            icon.image = [UIImage systemImageNamed:@"checkmark.circle.fill"];
            icon.tintColor = [UIColor systemGreenColor];
            label.text = @"Pay Success";
            break;

        case PaymentStatusExpired:
            icon.image = [UIImage systemImageNamed:@"exclamationmark.triangle.fill"];
            icon.tintColor = [UIColor systemYellowColor];
            label.text = @"The checkout session has expired";
            break;

        case PaymentStatusError:
            icon.image = [UIImage systemImageNamed:@"xmark.circle.fill"];
            icon.tintColor = [UIColor systemRedColor];
            label.text = @"Failed, please try again later";
            break;

        default:
            icon.image = [UIImage systemImageNamed:@"exclamationmark.circle.fill"];
            icon.tintColor = [UIColor systemOrangeColor];
            label.text = @"Error: payment result status";
            break;
    }

    [icon.widthAnchor constraintEqualToConstant:110].active = YES;
    [icon.heightAnchor constraintEqualToConstant:110].active = YES;

    [stack addArrangedSubview:icon];

    UIView *paddingBottom = [[UIView alloc] init];
    paddingBottom.translatesAutoresizingMaskIntoConstraints = NO;
    [paddingBottom.heightAnchor constraintEqualToConstant:100].active = YES;
    [stack addArrangedSubview:paddingBottom];

    [stack addArrangedSubview:label];
}

@end

NS_ASSUME_NONNULL_END
