//
//  HomeViewController.m
//  OcCheckoutDemo
//
//  Created by jiangzheng on 2025/12/1.
//

#import "HomeViewController.h"
#import "../ConfirmOrder/ConfirmOrderViewController.h"
#import "SettingSection.h"
#import "SettingItem.h"

NS_ASSUME_NONNULL_BEGIN

@interface HomeViewController () <UITableViewDelegate, UITableViewDataSource>

@property (nonatomic, strong) UITableView *tableView;
@property (nonatomic, strong) NSArray<SettingSection *> *sections;

@end

@implementation HomeViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.title = @"Checkout Demo";
    self.view.backgroundColor = [UIColor systemBackgroundColor];

    [self buildData];
    [self setupTableView];
}

#pragma mark - Data
- (void)buildData {
    SettingItem *item = [[SettingItem alloc]
                         initWithTitle:@"打开收银台"
                         subtitle:@"WebView方式"
                         page:@{
                             @"type": @"confirm_order",
                             @"extraData": @{@"sessionId": @"CS208693570923680499"}
                         }];

    SettingSection *section = [[SettingSection alloc]
                               initWithTitle:@""
                               items:@[item]];

    self.sections = @[section];
}

#pragma mark - UI
- (void)setupTableView {
    self.tableView = [[UITableView alloc]
                      initWithFrame:self.view.bounds
                      style:UITableViewStyleInsetGrouped];

    self.tableView.delegate = self;
    self.tableView.dataSource = self;
    self.tableView.autoresizingMask =
        UIViewAutoresizingFlexibleWidth | UIViewAutoresizingFlexibleHeight;

    [self.view addSubview:self.tableView];
}

#pragma mark - UITableViewDataSource
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return self.sections.count;
}

- (NSInteger)tableView:(UITableView *)tableView
 numberOfRowsInSection:(NSInteger)section {
    return self.sections[section].items.count;
}

- (NSString * _Nullable)tableView:(UITableView *)tableView
        titleForHeaderInSection:(NSInteger)section {
    NSString *title = self.sections[section].title;
    return title.length > 0 ? title : nil;
}

- (UITableViewCell *)tableView:(UITableView *)tableView
         cellForRowAtIndexPath:(NSIndexPath *)indexPath {

    static NSString *cellId = @"SettingCell";

    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:cellId];
    if (!cell) {
        cell = [[UITableViewCell alloc]
                initWithStyle:UITableViewCellStyleSubtitle
                reuseIdentifier:cellId];

        cell.accessoryType = UITableViewCellAccessoryDisclosureIndicator;
        cell.detailTextLabel.textColor = [UIColor systemGrayColor];
        cell.selectionStyle = UITableViewCellSelectionStyleDefault;
    }

    SettingItem *item = self.sections[indexPath.section].items[indexPath.row];
    cell.textLabel.text = item.title;
    cell.detailTextLabel.text = item.subtitle;

    return cell;
}

#pragma mark - UITableViewDelegate
- (void)tableView:(UITableView *)tableView
didSelectRowAtIndexPath:(NSIndexPath *)indexPath {

    [tableView deselectRowAtIndexPath:indexPath animated:YES];

    SettingItem *item = self.sections[indexPath.section].items[indexPath.row];

    NSDictionary *page = item.page;
    NSString *type = page[@"type"];

    if ([type isEqualToString:@"confirm_order"]) {
        ConfirmOrderViewController *vc =
            [[ConfirmOrderViewController alloc] initWithExtraData:page[@"extraData"]];
        [self.navigationController pushViewController:vc animated:YES];
    }
}

@end

NS_ASSUME_NONNULL_END
