//
//  ConfirmOrderViewController.m
//  OcCheckoutDemo
//
//  Created by jiangzheng on 2025/12/1.
//

#import "ConfirmOrderViewController.h"
#import "../PaymentComplete/PaymentCompleteViewController.h"
#import <PayKKaCheckoutPayments/PayKKaCheckoutPayments.h>

NS_ASSUME_NONNULL_BEGIN

@interface ConfirmOrderViewController ()

@property (nonatomic, strong) UIScrollView *scrollView;
@property (nonatomic, strong) UIView *contentView;

@property (nonatomic, strong) NSString *sessionId;
@property (nonatomic, assign) double price;

@end

@implementation ConfirmOrderViewController

- (instancetype)initWithExtraData:(NSDictionary *)extra {
    self = [super init];
    if (self) {
        _sessionId = extra[@"sessionId"] ?: @"";
        _price = 1118.83;
        
        // 设置 PayKKa 环境
        [PayKKa useEnv:PayKKaEnv.SANDBOX];
    }
    return self;
}

- (void)viewDidLoad {
    [super viewDidLoad];
    self.title = @"确认订单";
    self.view.backgroundColor = [UIColor systemGray6Color];

    [self buildScrollView];
    [self buildOrderCard];
    [self buildBottomPayButton];
}

- (void)buildScrollView {
    self.scrollView = [[UIScrollView alloc] init];
    self.scrollView.translatesAutoresizingMaskIntoConstraints = NO;
    [self.view addSubview:self.scrollView];

    [NSLayoutConstraint activateConstraints:@[
        [self.scrollView.topAnchor constraintEqualToAnchor:self.view.safeAreaLayoutGuide.topAnchor],
        [self.scrollView.leadingAnchor constraintEqualToAnchor:self.view.leadingAnchor],
        [self.scrollView.trailingAnchor constraintEqualToAnchor:self.view.trailingAnchor],
        [self.scrollView.bottomAnchor constraintEqualToAnchor:self.view.bottomAnchor]
    ]];

    self.contentView = [[UIView alloc] init];
    self.contentView.translatesAutoresizingMaskIntoConstraints = NO;
    [self.scrollView addSubview:self.contentView];

    [NSLayoutConstraint activateConstraints:@[
        [self.contentView.topAnchor constraintEqualToAnchor:self.scrollView.topAnchor],
        [self.contentView.leadingAnchor constraintEqualToAnchor:self.scrollView.leadingAnchor],
        [self.contentView.trailingAnchor constraintEqualToAnchor:self.scrollView.trailingAnchor],
        [self.contentView.bottomAnchor constraintEqualToAnchor:self.scrollView.bottomAnchor],
        [self.contentView.widthAnchor constraintEqualToAnchor:self.scrollView.widthAnchor]
    ]];
}

- (void)buildOrderCard {

    UIView *card = [[UIView alloc] init];
    card.backgroundColor = UIColor.systemBackgroundColor;
    card.layer.cornerRadius = 12;
    card.translatesAutoresizingMaskIntoConstraints = NO;
    [self.contentView addSubview:card];

    [NSLayoutConstraint activateConstraints:@[
        [card.topAnchor constraintEqualToAnchor:self.contentView.topAnchor constant:12],
        [card.leadingAnchor constraintEqualToAnchor:self.contentView.leadingAnchor constant:16],
        [card.trailingAnchor constraintEqualToAnchor:self.contentView.trailingAnchor constant:-16]
    ]];

    // 店铺
    UILabel *shopTitle = [[UILabel alloc] init];
    shopTitle.text = @"数码旗舰店";
    shopTitle.font = [UIFont boldSystemFontOfSize:17];
    shopTitle.translatesAutoresizingMaskIntoConstraints = NO;

    UIView *headerSeparator = [[UIView alloc] init];
    headerSeparator.backgroundColor = [[UIColor grayColor] colorWithAlphaComponent:0.2];
    headerSeparator.translatesAutoresizingMaskIntoConstraints = NO;

    [card addSubview:shopTitle];
    [card addSubview:headerSeparator];

    [NSLayoutConstraint activateConstraints:@[
        [shopTitle.topAnchor constraintEqualToAnchor:card.topAnchor constant:12],
        [shopTitle.leadingAnchor constraintEqualToAnchor:card.leadingAnchor constant:12],
        [shopTitle.trailingAnchor constraintEqualToAnchor:card.trailingAnchor constant:-12],
        [headerSeparator.topAnchor constraintEqualToAnchor:shopTitle.bottomAnchor constant:12],
        [headerSeparator.leadingAnchor constraintEqualToAnchor:card.leadingAnchor],
        [headerSeparator.trailingAnchor constraintEqualToAnchor:card.trailingAnchor],
        [headerSeparator.heightAnchor constraintEqualToConstant:0.5]
    ]];

    // 商品行
    UIImageView *icon = [[UIImageView alloc] initWithImage:[UIImage systemImageNamed:@"keyboard"]];
    icon.tintColor = UIColor.blueColor;
    icon.backgroundColor = [UIColor systemGray4Color];
    icon.layer.cornerRadius = 12;
    icon.clipsToBounds = YES;
    icon.contentMode = UIViewContentModeScaleAspectFit;
    icon.translatesAutoresizingMaskIntoConstraints = NO;
    [card addSubview:icon];

    UILabel *title = [[UILabel alloc] init];
    title.text = @"87 Keyboard";
    title.font = [UIFont boldSystemFontOfSize:15];
    title.translatesAutoresizingMaskIntoConstraints = NO;

    UILabel *priceLabel = [[UILabel alloc] init];
    priceLabel.text = [NSString stringWithFormat:@"券后 ¥%.2f", self.price];
    priceLabel.textColor = UIColor.systemBlueColor;
    priceLabel.font = [UIFont boldSystemFontOfSize:15];
    priceLabel.translatesAutoresizingMaskIntoConstraints = NO;

    UILabel *sku1 = [[UILabel alloc] init];
    sku1.text = @"SKU: KB-MECH87-BLUE-SW-V2";
    sku1.font = [UIFont systemFontOfSize:14];
    sku1.textColor = UIColor.grayColor;
    sku1.translatesAutoresizingMaskIntoConstraints = NO;

    UILabel *sku2 = [[UILabel alloc] init];
    sku2.text = @"Color: Midnight Blue";
    sku2.font = [UIFont systemFontOfSize:14];
    sku2.textColor = UIColor.grayColor;
    sku2.translatesAutoresizingMaskIntoConstraints = NO;

    [card addSubview:title];
    [card addSubview:priceLabel];
    [card addSubview:sku1];
    [card addSubview:sku2];

    [NSLayoutConstraint activateConstraints:@[
        [icon.topAnchor constraintEqualToAnchor:headerSeparator.bottomAnchor constant:12],
        [icon.leadingAnchor constraintEqualToAnchor:card.leadingAnchor constant:12],
        [icon.widthAnchor constraintEqualToConstant:70],
        [icon.heightAnchor constraintEqualToConstant:70],

        [title.topAnchor constraintEqualToAnchor:icon.topAnchor],
        [title.leadingAnchor constraintEqualToAnchor:icon.trailingAnchor constant:12],
        [title.trailingAnchor constraintEqualToAnchor:card.trailingAnchor constant:-12],

        [priceLabel.topAnchor constraintEqualToAnchor:title.topAnchor],
        [priceLabel.trailingAnchor constraintEqualToAnchor:card.trailingAnchor constant:-12],

        [sku1.topAnchor constraintEqualToAnchor:priceLabel.bottomAnchor constant:8],
        [sku1.leadingAnchor constraintEqualToAnchor:title.leadingAnchor],

        [sku2.topAnchor constraintEqualToAnchor:sku1.bottomAnchor constant:4],
        [sku2.leadingAnchor constraintEqualToAnchor:title.leadingAnchor],
        [sku2.bottomAnchor constraintEqualToAnchor:card.bottomAnchor constant:-20],
    ]];

}

- (void)buildBottomPayButton {

    UIButton *btn = [UIButton buttonWithType:UIButtonTypeSystem];
    btn.translatesAutoresizingMaskIntoConstraints = NO;

    NSString *text =
        [NSString stringWithFormat:@"立即支付 ¥ %.2f", self.price];

    [btn setTitle:text forState:UIControlStateNormal];
    [btn setTitleColor:UIColor.whiteColor forState:UIControlStateNormal];
    btn.titleLabel.font = [UIFont boldSystemFontOfSize:18];
    btn.backgroundColor = UIColor.systemBlueColor;
    btn.layer.cornerRadius = 12;

    [btn addTarget:self action:@selector(openCheckout)
   forControlEvents:UIControlEventTouchUpInside];

    [self.view addSubview:btn];

    [NSLayoutConstraint activateConstraints:@[
        [btn.leadingAnchor constraintEqualToAnchor:self.view.leadingAnchor constant:20],
        [btn.trailingAnchor constraintEqualToAnchor:self.view.trailingAnchor constant:-20],
        [btn.bottomAnchor constraintEqualToAnchor:self.view.safeAreaLayoutGuide.bottomAnchor constant:-10],
        [btn.heightAnchor constraintEqualToConstant:50]
    ]];
}

- (void)openCheckout {
    UINavigationController *nav = self.navigationController;
    UIViewController *presentingVC = nav.topViewController;
    [PayKKa goPay:presentingVC sessionId:@"CS208693570923680499" onPaymentCallback:^(PaymentResult * _Nonnull paymentResult) {
        PaymentCompleteViewController *vc = [[PaymentCompleteViewController alloc] initWithPaymentResult:paymentResult];
        switch (paymentResult.status) {
            case PaymentStatusSuccess: {
                NSArray *newStack = @[nav.viewControllers.firstObject, vc];
                [nav setViewControllers:newStack animated:YES];
                break;
            }
            case PaymentStatusExpired: {
                NSArray *newStack = @[nav.viewControllers.firstObject, vc];
                [nav setViewControllers:newStack animated:YES];
                NSLog(@"onExpired: %@", [paymentResult toString]);
                break;
            }
            default:
                NSLog(@"Unhandled payment status: %@", @(paymentResult.status));
                break;
        }
    }];
}

@end

NS_ASSUME_NONNULL_END
