package com.paykka.kotlincheckoutdemo.views

import androidx.compose.foundation.Image
import androidx.compose.foundation.layout.*
import androidx.compose.foundation.lazy.LazyColumn
import androidx.compose.foundation.lazy.items
import androidx.compose.material3.Divider
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.Scaffold
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.layout.ContentScale
import androidx.compose.ui.res.painterResource
import androidx.compose.ui.text.style.TextAlign
import androidx.compose.ui.unit.dp
import androidx.compose.ui.unit.sp
import com.paykka.android.checkout.PaymentResult
import com.paykka.kotlincheckoutdemo.R
@Composable
fun PaymentCompleteScreen(
    paymentResult: PaymentResult
) {
    val (imageRes, text) = when (paymentResult.status) {
        PaymentResult.Status.SUCCESS ->
            R.drawable.icon_check_circle_24px to "Pay Success"

        PaymentResult.Status.EXPIRED ->
            R.drawable.icon_warning_24px to
                    "The checkout session has expired. Please initiate the payment again."

        PaymentResult.Status.ERROR ->
            R.drawable.icon_cancel_24px to
                    "Failed, please try again later"

        else ->
            R.drawable.icon_warning_24px to "Unknown Payment status"
    }


    Scaffold { _ ->

        Column(
            modifier = Modifier
                .fillMaxSize()
                .padding(24.dp),
            horizontalAlignment = Alignment.CenterHorizontally,
            verticalArrangement = Arrangement.Center
        ) {

            Image(
                painter = painterResource(id = imageRes),
                contentDescription = null,
                modifier = Modifier
                    .size(110.dp),
                contentScale = ContentScale.Fit
            )

            Spacer(
                modifier = Modifier.height(100.dp)
            )

            Text(
                text = text,
                fontSize = 16.sp,
                color = MaterialTheme.colorScheme.onBackground,
                textAlign = TextAlign.Center
            )
        }
    }

}
