package com.paykka.kotlincheckoutdemo.views

import android.content.Intent
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.lazy.LazyColumn
import androidx.compose.foundation.lazy.items
import androidx.compose.material3.Divider
import androidx.compose.material3.Scaffold
import androidx.compose.runtime.Composable
import androidx.compose.runtime.remember
import androidx.compose.ui.Modifier
import androidx.compose.ui.platform.LocalContext
import com.paykka.kotlincheckoutdemo.ConfirmOrderActivity
import com.paykka.kotlincheckoutdemo.dto.HomeListItem

@Composable
fun HomeScreen() {
    val context = LocalContext.current

    val homeList = remember {
        listOf(
            HomeListItem(
                title = "打开收银台",
                subtitle = "WebView 方式",
                onClick = {
                    context.startActivity(
                        Intent(context, ConfirmOrderActivity::class.java)
                    )
                }
            )
        )
    }

    Scaffold { innerPadding ->
        LazyColumn(
            modifier = Modifier
                .fillMaxSize()
                .padding(innerPadding)
        ) {
            items(homeList) { item ->
                HomeListRow(item)
                Divider()
            }
        }
    }
}