package com.paykka.kotlincheckoutdemo

import android.os.Bundle
import androidx.activity.ComponentActivity
import androidx.activity.compose.setContent
import com.paykka.android.checkout.PaymentResult
import com.paykka.kotlincheckoutdemo.ui.theme.KotlinCheckoutDemoTheme
import com.paykka.kotlincheckoutdemo.views.PaymentCompleteScreen

class PaymentCompleteActivity : ComponentActivity() {

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)

        val statusString = intent.getStringExtra("paymentResult")
        val paymentResult = PaymentResult.fromString(statusString)

        setContent {
            KotlinCheckoutDemoTheme {
                PaymentCompleteScreen(paymentResult = paymentResult)
            }
        }
    }
}