package com.paykka.kotlincheckoutdemo

import android.app.ComponentCaller
import android.content.Intent
import android.os.Bundle
import android.util.Log
import androidx.activity.ComponentActivity
import androidx.activity.compose.setContent
import androidx.activity.result.ActivityResultLauncher
import androidx.activity.result.contract.ActivityResultContracts
import com.paykka.android.checkout.PayKKa
import com.paykka.android.checkout.PayKKaActivityResultLauncher
import com.paykka.android.checkout.PayKKaEnv
import com.paykka.android.checkout.PaymentResult
import com.paykka.android.checkout.wkwebview.PayKKaWKWebViewActivity
import com.paykka.kotlincheckoutdemo.ui.theme.KotlinCheckoutDemoTheme
import com.paykka.kotlincheckoutdemo.views.ConfirmOrderScreen

class ConfirmOrderActivity : ComponentActivity() {
    val TAG = "ConfirmOrderActivity"
    private lateinit var paykkaLauncher: PayKKaActivityResultLauncher;
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)

        paykkaLauncher = PayKKa.registerForActivityResult(this) {paymentResult ->
            val intent = Intent(this, PaymentCompleteActivity::class.java)
            intent.putExtra("paymentResult", paymentResult.toString())
            startActivity(intent)
            finish()
        }

        setContent {
            KotlinCheckoutDemoTheme {
                ConfirmOrderScreen {
                    goPay()
                }
            }
        }
    }

    private fun goPay() {
        // 切换 PayKKa 环境
        PayKKa.useEnv(PayKKaEnv.SANDBOX)
        paykkaLauncher.goPay("CS208780990151200199")
    }

    override fun onActivityResult(
        requestCode: Int,
        resultCode: Int,
        data: Intent?
    ) {
        super.onActivityResult(requestCode, resultCode, data)
    }
}