package com.paykka.javacheckoutdemo;

import android.os.Bundle;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;

import com.paykka.android.checkout.PaymentResult;

public class PaymentComplete extends AppCompatActivity {

    ImageView statusImage;
    TextView statusText;

    PaymentResult paymentResult;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_payment_complete);

        statusImage = findViewById(R.id.statusImage);
        statusText = findViewById(R.id.statusText);

        String status = getIntent().getStringExtra("paymentResult");
        paymentResult = PaymentResult.fromString(status);

        updateUI(paymentResult);
    }

    private void updateUI(PaymentResult paymentResult) {
        int imgResourceId = R.drawable.icon_warning_24px;
        String text = "Unknown Payment status";
        switch (paymentResult.getStatus()) {
            case SUCCESS:
                imgResourceId = R.drawable.icon_check_circle_24px;
                text = "Pay Success";
                break;
            case EXPIRED:
                imgResourceId = R.drawable.icon_warning_24px;
                text = "The checkout session has expired. Please initiate the payment again.";
                break;
            case ERROR:
                imgResourceId = R.drawable.icon_cancel_24px;
                text = "Failed, please try again later";
                break;
        }
        statusImage.setImageResource(imgResourceId);
        statusText.setText(text);
    }
}
