package com.paykka.javacheckoutdemo;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ListView;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;

import com.paykka.javacheckoutdemo.dto.HomeListItem;

import java.util.ArrayList;
import java.util.List;

public class HomeActivity extends AppCompatActivity {
    ListView listView;
    List<HomeListItem> homeList;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        setContentView(R.layout.activity_home);

        listView = findViewById(R.id.list_view);

        homeList = new ArrayList<>();

        HomeListAdapter homeListAdapter = new HomeListAdapter(this, android.R.layout.simple_list_item_2, homeList);
        listView.setAdapter(homeListAdapter);

        // HomeListItem - 打开收银台 - WebView方式
        homeList.add(new HomeListItem("打开收银台", "WebView 方式", () -> {
            Intent intent = new Intent(this, ConfirmOrderActivity.class);
            startActivity(intent);
        }));

        homeListAdapter.notifyDataSetChanged();

        listView.setOnItemClickListener((parent, view, position, id) -> {
            HomeListItem item = homeList.get(position);
            if (item.onClick != null) {
                item.onClick.run();
            }
        });
    }

    public static class HomeListAdapter extends ArrayAdapter<HomeListItem> {
        private final int resourceId;
        public HomeListAdapter(Context context, int resource, List<HomeListItem> objects) {
            super(context, resource, objects);
            resourceId = resource;
        }
        @NonNull
        @Override
        public View getView(int position, @Nullable View convertView, @NonNull ViewGroup parent) {
            View view;
            if (convertView == null) {
                view = LayoutInflater.from(getContext()).inflate(resourceId, parent, false);
            } else {
                view = convertView;
            }

            HomeListItem item = getItem(position);

            if (item != null) {
                TextView title = view.findViewById(android.R.id.text1);
                TextView subtitle = view.findViewById(android.R.id.text2);

                title.setText(item.title);
                subtitle.setText(item.subtitle);
            }

            return view;
        }
    }
}
