package com.paykka.javacheckoutdemo;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;

import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;

import com.paykka.android.checkout.PayKKa;
import com.paykka.android.checkout.PayKKaEnv;

public class ConfirmOrderActivity extends AppCompatActivity {

    Button btnPay;
    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_confirm_order);

        Activity context = this;
        // 切换PayKKa收银台的环境
        PayKKa.useEnv(PayKKaEnv.SANDBOX);
        btnPay = findViewById(R.id.btn_pay);
        btnPay.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                PayKKa.goPay(context, "CS208780943566368705", (paymentResult) -> {
                    Intent intent = new Intent(context, PaymentComplete.class);
                    intent.putExtra("paymentResult", paymentResult.toString());
                    startActivity(intent);
                    context.finish();
                });
            }
        });
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        PayKKa.onPaymentResult(requestCode, resultCode, data);
    }
}
